/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.block;

import java.util.Random;
import net.creeperhost.soulshardsrespawn.block.TileEntitySoulCage;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BlockSoulCage
extends BaseEntityBlock {
    public static final Property<Boolean> POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final Property<Boolean> ACTIVE = BooleanProperty.m_61465_((String)"active");

    public BlockSoulCage() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof TileEntitySoulCage) {
                TileEntitySoulCage tile = (TileEntitySoulCage)t;
                tile.tick();
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_20161_()) {
            return InteractionResult.PASS;
        }
        TileEntitySoulCage cage = (TileEntitySoulCage)world.m_7702_(pos);
        if (cage == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = cage.getInventory().extractItem(0, 1, false);
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState state2, boolean someBool) {
        this.handleRedstoneChange(world, state, pos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean someBool) {
        this.handleRedstoneChange(world, state, pos);
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_(POWERED)).booleanValue() && !world.m_46753_(pos)) {
            world.m_7731_(pos, (BlockState)state.m_61124_(POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState blockState2, boolean someBool) {
        TileEntitySoulCage cage;
        if (state.m_60734_() != blockState2.m_60734_() && (cage = (TileEntitySoulCage)world.m_7702_(pos)) != null) {
            ItemStack stack = cage.getInventory().getStackInSlot(0);
            Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}));
        }
        super.m_6810_(state, world, pos, blockState2, someBool);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @javax.annotation.Nullable Direction side) {
        return true;
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        TileEntitySoulCage cage = (TileEntitySoulCage)world.m_7702_(pos);
        if (cage == null) {
            return 0;
        }
        Binding binding = cage.getBinding();
        if (binding == null) {
            return 0;
        }
        return (int)((double)binding.getTier().getIndex() / ((double)Tier.INDEXED.size() - 1.0) * 15.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, ACTIVE});
    }

    private void handleRedstoneChange(Level world, BlockState state, BlockPos pos) {
        boolean powered = world.m_46753_(pos);
        if (((Boolean)state.m_61143_(POWERED)).booleanValue() && !powered) {
            world.m_7731_(pos, (BlockState)state.m_61124_(POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.m_61143_(POWERED)).booleanValue() && powered) {
            world.m_7731_(pos, (BlockState)state.m_61124_(POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntitySoulCage(blockPos, blockState);
    }
}

